<?php 
	global $post;
	$icons = get_post_meta( $post->ID, '_ebor_team_social_icons', true );
	$protocols = array(  'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet', 'skype' );
?>

<div class="do-team-member">
    
    <?php the_post_thumbnail('full'); ?>
    
    <div class="do-member-details">
        <?php the_title('<h3><a href="'. get_permalink() .'">', '</a></h3><p>'. get_post_meta($post->ID, '_ebor_the_job_title', 1) .'</p>'); ?>
		
		<?php if( is_array($icons) ) : ?>
			<ul>
				<?php 
					foreach( $icons as $key => $icon ){
						if(!( isset( $icon['_ebor_social_icon_url'] ) ))
							continue;
							
						echo '<li><a href="'. esc_url($icon['_ebor_social_icon_url'], $protocols) .'" target="_blank"><i class="'. esc_attr($icon['_ebor_social_icon']) .'"></i></a></li>';
					}
				?>
			</ul>
		<?php endif; ?>

    </div>
</div>