<?php 

/**
 * Returns Fourth Header 
 * 
 * @since v1.0.0
 * @package Do
 * @author Jewel Theme
 */


	$phone = get_option('do_header_phone', '+00 (123) 456 78 90');
	$email = get_option('do_header_email', 'info@themebeer.com');
	$header_side_nav = get_option('header_side_nav', 'yes');
	
	$logo = get_option('custom_logo', EBOR_THEME_DIRECTORY . 'style/images/logo.png');
?>

<header class="hastopbar">

	<div class="do-header-topbar">
	    <div class="container">
	        <div class="row">
	        
	            <div class="do-topbar-content-wrap do-topbar-content-left">
	                <ul>
	                	<?php	
	                		if( $email )
	                			echo '<li><i class="fa fa-envelope-o"></i>'. $email .'</li>';
	                			
	                		if( $phone )
	                			echo '<li><i class="fa fa-phone"></i>'. $phone .'</li>';
	                	?>
	                </ul>
	            </div>
	
	            <div class="do-topbar-content-wrap do-topbar-content-right">
	                <ul>
	                    <?php
	                    	$protocols = array('http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet', 'skype');
	                    	
	                    	for( $i = 1; $i < 7; $i++ ){
	                    		if( get_option("header_social_url_$i") ) {
	                    			echo '<li>
	                    				      <a href="' . esc_url(get_option("header_social_url_$i"), $protocols) . '" target="_blank">
	                    					      <i class="' . get_option("header_social_icon_$i") . '"></i>
	                    				      </a>
	                    				  </li>';
	                    		}
	                    	} 
	                    ?>
	                </ul>
	            </div>
	            
	        </div>
	    </div>
	</div>
	        
    <nav class="navbar do-main-menu">
        <div class="container">

            <div class="navbar-header">
            
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>

                <?php if( $header_side_nav == "yes" ){ ?>
	                <button class="do-side-menu-button" id="do-side-menu-open-button"></button>
                <?php } ?>

                <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                	<img class="logo" alt="<?php echo esc_attr(get_bloginfo('title')); ?>" src="<?php echo esc_url($logo); ?>" />
                </a>

            </div>

            <div id="nav-menu" class="navbar-collapse do-menu-wrapper collapse">
            	<?php
            		if ( has_nav_menu( 'primary' ) ){
            			wp_nav_menu( 
            				array(
            				    'theme_location'    => 'primary',
            				    'depth'             => 3,
            				    'container'         => 'ul',
            				    'container_class'   => 'nav navbar-nav do-menus',
            				    'menu_class'   => 'nav navbar-nav do-menus',
            				    'menu_id'           => false
            				)
            			);
            		} else {
            			echo '<ul class="nav navbar-nav do-menus"><li>Set a menu up in "appearance" => "menus"</li></ul>';
            		}
            	?>
            </div>

        </div>
    </nav>
    
</header>