<?php 

/**
 * Here is all the custom colours for the theme.
 * $handle is a reference to the handle used with wp_enqueue_style()
 */
if(!( function_exists('ebor_less_vars') )){ 
	function ebor_less_vars( $vars, $handle = 'ebor-theme-styles' ) {
		
		$vars['white']           = get_option('do_colour_white', '#fff');
		$vars['black']           = get_option('do_colour_black', '#000');
		$vars['dark']            = get_option('do_colour_dark', '#333');
		$vars['highlight']       = get_option('do_colour_highlight', '#fc7f0c');
		$vars['highlight2']      = get_option('do_colour_highlight2', '#ffc000');
		$vars['highlight3']      = get_option('do_colour_highlight3', '#e84b3a');
		$vars['highlight4']      = get_option('do_colour_highlight4', '#474747');
		$vars['light']           = get_option('do_colour_light', '#888888');
		$vars['meta']            = get_option('do_colour_meta', '#e9e9e9');
		$vars['grey']            = get_option('do_colour_grey', '#c0c0c0');
		
	    return $vars;
	}
	add_filter( 'less_vars', 'ebor_less_vars', 10, 2 );
}

/**
 * Ebor Load Scripts
 * Properly Enqueues Scripts & Styles for the theme
 * @since version 1.0
 * @author TommusRhodus
 */ 
if(!( function_exists('ebor_load_scripts') )){
	function ebor_load_scripts() {

		$protocol = is_ssl() ? 'https' : 'http';
		$body_font = get_option('body_font_url', $protocol . '://fonts.googleapis.com/css?family=Open+Sans:400,600,700');
		$heading_font = get_option('heading_font_url', $protocol . '://fonts.googleapis.com/css?family=Roboto:300,400,700');

				//Enqueue Fonts
		if( $body_font )
			wp_enqueue_style( 'ebor-open-sans-font', esc_url($body_font) );
			
		if( $heading_font )
			wp_enqueue_style( 'ebor-heading-font', esc_url($heading_font) );

		//Enqueue Styles
		wp_enqueue_style( 'ebor-bootstrap', EBOR_THEME_DIRECTORY . 'style/css/bootstrap.min.css' );
		wp_enqueue_style( 'ebor-plugins', EBOR_THEME_DIRECTORY . 'style/css/plugins.css' );
		wp_enqueue_style( 'ebor-animate', EBOR_THEME_DIRECTORY . 'style/css/animate.min.css' );
		wp_enqueue_style( 'ebor-fonts', EBOR_THEME_DIRECTORY . 'style/css/fonts.css' );	

		//if ( ! class_exists( 'wp_less' ) ) {
		 	wp_enqueue_style( 'ebor-theme-style', EBOR_THEME_DIRECTORY . 'style/css/theme.min.css' );
		// } else{			
		// 	wp_enqueue_style( 'ebor-theme-styles', EBOR_THEME_DIRECTORY . 'style/css/theme.less' );
		// }
		wp_enqueue_style( 'ebor-style', get_stylesheet_uri() );
		
		//Enqueue Scripts
		wp_enqueue_script( 'ebor-modernizr', EBOR_THEME_DIRECTORY . 'style/js/modernizr-2.8.3.min.js', array('jquery'), false, false );
		wp_enqueue_script( 'ebor-plugins', EBOR_THEME_DIRECTORY . 'style/js/plugins.js', array('jquery'), false, true  );
		wp_enqueue_script( 'ebor-scripts', EBOR_THEME_DIRECTORY . 'style/js/main.js', array('jquery'), false, true  );
		
		//Enqueue Comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		
		$custom_css = get_option('custom_css');
		wp_add_inline_style( 'ebor-style', $custom_css );
	}
	add_action('wp_enqueue_scripts', 'ebor_load_scripts', 110);
}

/**
 * Ebor Load Admin Scripts
 * Properly Enqueues Scripts & Styles for the theme
 * 
 * @since version 1.0
 * @author TommusRhodus
 */
if(!( function_exists('ebor_admin_load_scripts') )){
	function ebor_admin_load_scripts(){
		wp_enqueue_style( 'ebor-theme-admin-css', EBOR_THEME_DIRECTORY . 'admin/ebor-theme-admin.css' );
		wp_enqueue_style( 'ebor-fonts', EBOR_THEME_DIRECTORY . 'style/css/fonts.css' );	
		wp_enqueue_script( 'ebor-theme-admin-js', EBOR_THEME_DIRECTORY . 'admin/ebor-theme-admin.js', array('jquery'), false, true  );
	}
	add_action('admin_enqueue_scripts', 'ebor_admin_load_scripts', 200);
}