<?php 

/**
 * The Shortcode
 */
function ebor_small_images_shortcode( $atts, $content = null ) {
	extract( 
		shortcode_atts( 
			array(
				'slides' => ''
			), $atts 
		) 
	);
	
	$slides = explode(',', $slides);
	$i = 0;
	
	$output = '<div class="do-animated-img-wrapper col-md-12 col-sm-12 col-xs-12"><ul class="hidden-xs">';
	
	if( is_array($slides) ){
		foreach( $slides as $ID ){
			$delay = $i * 500;
			$output .= '
				<li class="appear slideInUp" data-wow-duration="1s" data-wow-delay="'. esc_attr($delay) .'ms">
				    '. wp_get_attachment_image( $ID, 'full' ) .'
				</li>
			';
			$i++;	
		}
	}

	$output .= '</ul></div>';
	
	return $output;
}
add_shortcode( 'do_small_images', 'ebor_small_images_shortcode' );

/**
 * The VC Functions
 */
function ebor_small_images_shortcode_vc() {
	vc_map( 
		array(
			"icon" => 'do-vc-block',
			"name" => __("Small Image Row", 'do'),
			"base" => "do_small_images",
			"category" => __('do WP Theme', 'do'),
			"params" => array(
				array(
					"type" => "attach_images",
					"heading" => __("Slider Images (use 5)", 'do'),
					"param_name" => "slides"
				)
			)
		) 
	);
}
add_action( 'vc_before_init', 'ebor_small_images_shortcode_vc' );