<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $link
 * @var $size
 * @var $el_class
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Gmaps
 */
$title = $link = $size = $el_class = $css = '';
$output = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$zoom = 14; // deprecated 4.0.2. In 4.6 was moved outside from shortcode_atts
$type = 'm'; // deprecated 4.0.2
$bubble = ''; // deprecated 4.0.2

if ( '' === $link ) {
	return null;
}
$link = trim( vc_value_from_safe( $link ) );
$bubble = ( $bubble !== '' && $bubble !== '0' ) ? '&amp;iwloc=near' : '';
$size = str_replace( array( 'px', ' ' ), array( '', '' ), $size );

if ( is_numeric( $size ) ) {
	$link = preg_replace( '/height="[0-9]*"/', 'height="' . $size . '"', $link );
}

$class_to_filter = 'wpb_gmaps_widget wpb_content_element'.( $size === ''  ? ' vc_map_responsive' : '');
$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts );

?>

<section class="do-contactmap-section">

    <div class="do-google-map">
        <?php
        	if ( preg_match( '/^\<iframe/', $link ) ) {
        		echo htmlspecialchars_decode($link);
        	} else {
        		// TODO: refactor or remove outdated/deprecated attributes that is not mapped in gmaps.
        		echo '<iframe width="100%" height="550" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="' . $link . '&amp;t=' . $type . '&amp;z=' . $zoom . '&amp;output=embed' . $bubble . '"></iframe>';
        	}
        ?>
    </div>

   	<?php if( $content ) : ?>
	    <div class="do-home-contact-form-bg"></div>
	    <div class="do-home-contact-form">
	        <div class="do-home-contact-form-inner">
	            <?php echo wpautop(do_shortcode(htmlspecialchars_decode($content))); ?>
	        </div>
	    </div>
    <?php endif; ?>

</section>