<?php
	/**
	 * This loop is used to create items for the portfolio archives and also the homepage template.
	 * Any custom functions prefaced with ebor_ are found in /admin/theme_functions.php
	 * First let's declare $post so that we can easily grab everthing needed.
	 */
	 global $post;
	 
	 /**
	  * Next, we need to grab the featured image URL of this post, so that we can trim it to the correct size for the chosen size of this post.
	  */
	 $url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full');

	 if(!( $url[0] ))
	 	$url[0] = false;
?>

<div class="do-creative-blog-items do-blog-items" style="background-image: url(<?php echo esc_url($url[0]); ?>)">
    <div class="do-blog-content">
    
        <div <?php post_class();?>>
            <div class="do-blog-date-wrapper col-md-1 col-sm-2 col-xs-2">
                <span class="do-date">
                    <span class="do-day"><?php echo get_the_time('d'); ?></span>
                    <span class="do-mon"><?php echo get_the_time('M'); ?></span>
                </span>
            </div>

            <div class="do-blog-title-author col-md-10 col-sm-8 col-xs-8">
                <?php 
                	the_title('<h3><a href="'. get_permalink() .'">', '</a></h3>'); 
                	the_author_posts_link();	
                ?>
            </div>
        </div>
        
    </div>
</div>