<?php
	/**
	 * This loop is used to create items for the portfolio archives and also the homepage template.
	 * Any custom functions prefaced with ebor_ are found in /admin/theme_functions.php
	 * First let's declare $post so that we can easily grab everthing needed.
	 */
	 global $post;
	 
	 /**
	  * Next, we need to grab the featured image URL of this post, so that we can trim it to the correct size for the chosen size of this post.
	  */
	 $url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full');

	 /**
	  * Leave this portfolio item out if we didn't find a featured image.
	  */
	 if(!( $url[0] ))
	 	return false;
	 	
	 if( get_post_format() == 'video' )
	 	$url[0] = get_post_meta( $post->ID, "_ebor_the_oembed", true );
?>


<div class="do-work-item <?php echo get_post_meta( $post->ID, "_ebor_portfolio_style", true );?> <?php echo ebor_the_terms('portfolio_category', ' ', 'slug'); ?>">
    <div class="do-work-item-inner-wrap">
    
        <?php the_post_thumbnail('large'); ?>
        
        <div class="do-work-item-hover">
        
            <a href="<?php the_permalink(); ?>" class="do-single-page-link"></a>
            
            <div class="do-work-item-details">
                <?php the_title('<h3 class="do-work-item-title"><a href="'. get_permalink() .'">', '</a></h3>'); ?>
                <span class="do-work-item-subtitle"><?php echo ebor_the_terms('portfolio_category', ', ', 'name'); ?></span>
            </div>
            
            <a href="<?php echo esc_url($url[0]); ?>" class="do-work-item-popup"></a>
            
        </div>
        
    </div>
</div>