<?php 

/**
 * Returns 2nd Header 
 * 
 * @since v1.0.0
 * @package Do
 * @author Jewel Theme
 */
	
	$logo = get_option('custom_logo', EBOR_THEME_DIRECTORY . 'style/images/logo.png');
    $header_side_nav = get_option('header_side_nav', 'yes');
?>
    <header>
        <!-- <div class="do-color-parallax-overlay-2"></div> -->
        <!-- Navigation Menu start-->
        <nav class="navbar do-main-menu">
            <div class="container">

                <!-- Navbar Toggle -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>

                    <!-- Logo -->
                    <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                    	<img class="logo" alt="<?php echo esc_attr(get_bloginfo('title')); ?>" src="<?php echo esc_url($logo); ?>" />
                    </a>

                </div>
                <!-- Navbar Toggle End -->

                <!-- navbar-collapse start-->
                <div id="nav-menu" class="navbar-collapse do-menu-wrapper collapse">
                	<?php
                	if ( has_nav_menu( 'primary' ) ){
                		wp_nav_menu( 
                			array(
                				'theme_location'    => 'primary',
                				'depth'             => 3,
                				'container'         => 'ul',
                				'container_class'   => 'nav navbar-nav do-menus',
                				'menu_class'   => 'nav navbar-nav do-menus',
                				'menu_id'           => false
                				)
                			);
                	} else {
                		echo '<ul class="nav navbar-nav do-menus"><li>Set a menu up in "appearance" => "menus"</li></ul>';
                	}
                	?>
                </div>
                <!-- navbar-collapse end-->

                <!-- SIDE MENU BTN -->
                <?php if( $header_side_nav == "yes" ){ ?>
                    <div class="do-side-menu-opener">
                        <button class="do-side-menu-button" id="do-side-menu-open-button"></button>
                    </div>
                <?php } ?>
                <!-- SIDE MENU BTN END -->

            </div>
        </nav>
        <!-- Navigation Menu end-->
    
    </header>
    <!-- HEADER END -->