<?php
	/**
	 * comments.php
	 * @author TommusRhodus
	 * @since 1.0.0
	 */
	$custom_comment_form = array(
		'fields' => apply_filters( 'comment_form_default_fields', array(
		    'author' => '<input type="text" id="name" name="author" placeholder="' . esc_html__('Name *','do') . '" value="' . esc_attr( $commenter['comment_author'] ) . '" />',
		    'email'  => '<input name="email" type="text" id="email" placeholder="' . esc_html__('Email *','do') . '" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" />',
		    'url'    => '<input name="url" type="text" id="website" placeholder="' . esc_html__('Website','do') . '" value="' . esc_attr(  $commenter['comment_author_url'] ) . '" />')
		),
		'comment_field' => '<textarea name="comment" placeholder="' . esc_html__('Your Comment Here','do') . '" id="message" aria-required="true" rows="3"></textarea>',
		'cancel_reply_link' => esc_html__( 'Cancel' , 'do' ),
		'comment_notes_before' => '',
		'comment_notes_after' => '',
		'label_submit' => esc_html__( 'Submit' , 'do' )
	);
?>

<div class="do-blog-comments-wrapper do-comment-form-wrapper do-blog-single-inner-sec">

    <h2><?php comments_number( esc_html__('0 Comments','do'), esc_html__('1 Comment','do'), esc_html__('% Comments','do') ); ?></h2>

    <?php
    	if( have_comments() ){
    		wp_list_comments('type=comment&callback=ebor_custom_comment');
    		paginate_comments_links();
    	}
    ?>

</div>

<div class="do-comment-form-wrapper do-blog-single-inner-sec">
	<?php comment_form($custom_comment_form); ?>
</div>