<?php 

/**
 * Build theme options
 * Uses the Ebor_Options class found in the ebor-framework plugin
 * Panels are WP 4.0+!!!
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if( class_exists('Ebor_Options') ){
	$ebor_options = new Ebor_Options;
	
	/**
	* Variables
	*/
	$theme = wp_get_theme();
	$theme_name = $theme->get( 'Name' );
	$header_layouts = ebor_get_header_options();
	$blog_layouts = array_flip(ebor_get_blog_layouts());
	$portfolio_layouts = array_flip(ebor_get_portfolio_layouts());
	$post_types = get_post_types();
	
	$shop_archive_layouts = array(
		'sidebar-left' => 'Left Sidebar',
		'sidebar-right' => 'Right Sidebar',
		'4col' => 'No Sidebar (4 Columns)',
		'3col' => 'No Sidebar (3 Columns)',
		'2col' => 'No Sidebar (2 Columns)',
	);

	$select_options = array(
		'yes' => 'Yes',
		'no' => 'No',
	);

	$blog_post_layouts = array(
		'sidebar-right' => 'Right Sidebar',
		'sidebar-none' => 'No Sidebar'
		);

	$social_options = ebor_get_icons();
	foreach( $social_options as $social ){
		$new_social_options[$social] = ucfirst(str_replace('ti-', '', $social));	
	}
	
	$fonts_description = 'Fonts: ' . $theme_name . ' uses Google Fonts, <a href="https://www.google.com/fonts" target="_blank">all of which are viewable here</a>. Unlike some themes, ' . $theme_name . ' does not load all of these fonts into these options, in avoiding this ' . $theme_name . ' can work faster and more reliably.<br /><br />	
	To customize the fonts on your website use the URL above and the inputs below accordingly. Full details of this process (and the default values) can be found in the theme documentation!';
	
	/**
	 * Default stuff
	 * 
	 * Each of these is a default option that appears in each theme, demo data, favicons and a custom css input
	 * 
	 * @since 1.0.0
	 * @author tommusrhodus
	 */
	$ebor_options->add_panel( $theme_name . ': Demo Data', 5, '');
	$ebor_options->add_panel( $theme_name . ': Styling Settings', 205, 'All of the controls in this section directly relate to the styling page of ' . $theme_name);
	$ebor_options->add_section('demo_data_section', 'Import Demo Data', 10, $theme_name . ': Demo Data', '<strong>Please read this before importing demo data via this control:</strong><br /><br />The demo data this will install includes images from my demo site with <strong>heavy blurring applied</strong> this is due to licensing restrictions. Simply replace these images with your own.<br /><br />Note that this process can take up to 15mins on slower servers, go make a cup of tea. If you havn\'t had a notification in 30mins, use the fallback method outlined in the written documentation.<br /><br />');
	$ebor_options->add_section('custom_css_section', 'Custom CSS', 40, $theme_name . ': Styling Settings');
	$ebor_options->add_setting('demo_import', 'demo_import', 'Import Demo Data', 'demo_data_section', '', 10);
	$ebor_options->add_setting('textarea', 'custom_css', 'Custom CSS', 'custom_css_section', '', 30);



	/**
	 * Panels
	 * 
	 * add_panel($name, $priority, $description)
	 * 
	 * @since 1.0.0
	 * @author tommusrhodus
	 */
	$ebor_options->add_panel( $theme_name . ': Site Settings', 210, 'All of the controls in this section directly relate to the site settings of ' . $theme_name);
	$ebor_options->add_panel( $theme_name . ': Customize Settings', 215, 'All of the controls in this section directly relate to the header and logos of ' . $theme_name);
	$ebor_options->add_panel( $theme_name . ': Blog Settings', 225, 'All of the controls in this section directly relate to the control of blog items within ' . $theme_name);
	$ebor_options->add_panel( $theme_name . ': Portfolio Settings', 230, 'All of the controls in this section directly relate to the control of portfolio items within ' . $theme_name);
	$ebor_options->add_panel( $theme_name . ': Footer Settings', 290, 'All of the controls in this section directly relate to the control of the footer within ' . $theme_name);
	$ebor_options->add_panel( $theme_name . ': Visual Composer Settings', 295, 'All of the controls in this section directly relate to the control of visual composer within ' . $theme_name);






/**
	 * Sections
	 * 
	 * add_section($name, $title, $priority, $panel, $description)
	 * 
	 * @since 1.0.0
	 * @author tommusrhodus
*/

	//Styling
	$ebor_options->add_section('fonts_section', 'Fonts', 5, $theme_name . ': Styling Settings', $fonts_description);

	//Blog Sections
	$ebor_options->add_section('blog_settings', 'Blog Settings', 1, $theme_name . ': Blog Settings');
	
	//Blog Title
	$ebor_options->add_section('blog_title_section', 'Blog Title Bar', 15, $theme_name . ': Blog Settings');
	$ebor_options->add_setting('select', 'do_blog_header_layout', 'Blog Title Layout', 'blog_title_section', 'left-short-grey', 5);
	$ebor_options->add_setting('input', 'blog_title', 'Blog Title', 'blog_title_section', 'OUR BLOG', 10);
	$ebor_options->add_setting('input', 'blog_subtitle', 'Blog Subtitle', 'blog_title_section', 'PLACE FOR BLOG', 15);
	$ebor_options->add_setting('image', 'do_blog_header_image', 'Blog Header Background', 'blog_title_section', '', 20);


		//Fonts
	$ebor_options->add_setting('input', 'body_font', 'Body Font', 'fonts_section', 'Open Sans', 10);
	$ebor_options->add_setting('textarea', 'body_font_url', 'Body Font URL Parameter', 'fonts_section', 'http://fonts.googleapis.com/css?family=Open+Sans:400,600,700', 15);
	$ebor_options->add_setting('input', 'heading_font', 'Heading Font', 'fonts_section', 'Roboto', 20);
	$ebor_options->add_setting('textarea', 'heading_font_url', 'Heading Font URL Parameter', 'fonts_section', 'http://fonts.googleapis.com/css?family=Roboto:300,400,700', 25);


	//Colour Options
	$ebor_options->add_setting('color', 'do_colour_white', 'Light Wrapper Colour', 'colors', '#fff', 1);
	$ebor_options->add_setting('color', 'do_colour_black', 'Dark Wrapper Colour', 'colors', '#000', 5);
	$ebor_options->add_setting('color', 'do_colour_dark', 'Black Wrapper Colour', 'colors', '#333', 7);
	$ebor_options->add_setting('color', 'do_colour_grey', 'Link Color', 'colors', '#c0c0c0', 20);
	$ebor_options->add_setting('color', 'do_colour_highlight', 'Highlight Colour 1', 'colors', '#fc7f0c', 10);
	$ebor_options->add_setting('color', 'do_colour_highlight2', 'Highlight Colour 2', 'colors', '#ffc000', 10);
	$ebor_options->add_setting('color', 'do_colour_highlight3', 'Highlight Colour 3', 'colors', '#e84b3a', 10);
	$ebor_options->add_setting('color', 'do_colour_highlight4', 'Highlight Colour 4', 'colors', '#474747', 10);
	$ebor_options->add_setting('color', 'do_colour_light', 'Body Font Color', 'colors', '#888888', 15);
	$ebor_options->add_setting('color', 'do_colour_meta', 'Button Round Outline', 'colors', '#e9e9e9', 20);



	
	//portfolio Title
	$ebor_options->add_section('portfolio_title_section', 'Portfolio Title Bar', 15, $theme_name . ': Portfolio Settings');
	$ebor_options->add_setting('select', 'do_portfolio_header_layout', 'Portfolio Title Layout', 'portfolio_title_section', 'left-short-grey', 5);
	$ebor_options->add_setting('input', 'portfolio_title', 'Portfolio Title', 'portfolio_title_section', 'Our Work', 10);
	$ebor_options->add_setting('input', 'portfolio_subtitle', 'Portfolio Subtitle', 'portfolio_title_section', 'Our Creative Work', 15);
	$ebor_options->add_setting('image', 'do_portfolio_header_image', 'Portfolio Header Background', 'portfolio_title_section', '', 20);
	$ebor_options->add_setting('image', 'do_portfolio_header_image', 'Portfolio Header Background', 'portfolio_title_section', '', 20);

	
	//Portfolio Sections
	$ebor_options->add_section('portfolio_text_section', 'Portfolio Settings', 15, $theme_name . ': Portfolio Settings');
	$ebor_options->add_section('blog_text_section', 'Blog Settings', 5, $theme_name . ': Blog Settings');
	
	//Header Settings
	$ebor_options->add_section('logo_settings_section', 'Logo Settings', 10, $theme_name . ': Customize Settings');
	$ebor_options->add_section('preloader_logo_settings_section', 'Preloader Setting', 10, $theme_name . ': Customize Settings');	
	$ebor_options->add_section('header_layout_section', 'Header Layout', 5, $theme_name . ': Customize Settings', 'This setting controls the theme header site-wide. If you need to you can override this setting on specific posts and pages from within that posts edit screen.');
	$ebor_options->add_section('sub_header_layout_section', 'Top Header Settings', 10, $theme_name . ': Customize Settings', 'This setting controls the theme header site-wide. If you need to you can override this setting on specific posts and pages from within that posts edit screen.');
	$ebor_options->add_section('header_side_navigation', 'Off-Canvas Navigation Settings', 20, $theme_name . ': Customize Settings', 'This setting controls the theme header site-wide. If you need to you can override this setting on specific posts and pages from within that posts edit screen.');
	
	//Footer Settings
	$ebor_options->add_section('footer_social_settings_section', 'Footer Icons Settings', 40, $theme_name . ': Footer Settings', '');
	$ebor_options->add_section('footer_layout_section', 'Footer Layout', 5, $theme_name . ': Footer Settings', 'This setting controls the theme footer site-wide. If you need to you can override this setting on specific posts and pages from within that posts edit screen.');
	$ebor_options->add_section('subfooter_settings_section', 'Copyright Settings', 30, $theme_name . ': Footer Settings');
	$ebor_options->add_section('footer_social_settings_section', 'Footer Icons Settings', 40, $theme_name . ': Footer Settings', 'These social icons are only shown in certain footer layouts.');


	/**
	 * Settings (The Actual Options)
	 * Repeated settings are stepped using a for() loop and counter
	 * 
	 * add_setting($type, $option, $title, $section, $default, $priority, $select_options)
	 * 
	 * @since 1.0.0
	 * @author tommusrhodus
	 */


	//Portfolio options
	$ebor_options->add_setting('select', 'portfolio_layout', 'Portfolio Archives Layout', 'portfolio_text_section', 'parallax', 30, $portfolio_layouts);
	$ebor_options->add_setting('input',  'portfolio_related_text', 'Portfolio Related Text', 'portfolio_text_section', 'Related Work', 30);
	$ebor_options->add_setting('input',  'portfolio_related_portfolio', 'Related Portfolio Count', 'portfolio_text_section', '8', 30);
	
	//Blog Options
	$ebor_options->add_setting('select', 'do_post_layout', 'Blog Posts Layout', 'blog_text_section', 'sidebar-right', 10, $blog_post_layouts);
	$ebor_options->add_setting('select', 'blog_layout', 'Blog Archives Layout', 'blog_text_section', 'masonry-sidebar-right', 15, $blog_layouts);
	
	//Logo Options
	$ebor_options->add_setting('image', 'custom_logo', 'Header Logo', 'logo_settings_section', EBOR_THEME_DIRECTORY . 'style/images/logo.png', 5);
	$ebor_options->add_setting('image', 'custom_logo_sidebar', 'Sidebar Menu Logo', 'logo_settings_section', EBOR_THEME_DIRECTORY . 'style/images/side-menu-logo.png', 10);
	$ebor_options->add_setting('image', 'side_menu_background', 'Sidebar Menu Background', 'logo_settings_section', EBOR_THEME_DIRECTORY . 'style/images/menu-bg.jpg', 10);
	$ebor_options->add_setting('range', 'logo_height', 'Logo Height (42px*25px Default)(% height of bar)', 'logo_settings_section', '42', 15, array('min' => '0', 'max' => '100', 'step' => '1'));
	$ebor_options->add_setting('range', 'nav_height', 'Nav Height (70 Default)', 'logo_settings_section', '70', 15, array('min' => '70', 'max' => '110', 'step' => '1'));
	
	//Preloader Logo Options
	$ebor_options->add_setting('image', 'preloader_logo', 'Preloader Logo', 'preloader_logo_settings_section', EBOR_THEME_DIRECTORY . 'style/images/controls/preloader-logo.png', 5);


	//Footer Options
	$ebor_options->add_setting('textarea', 'do_footer_copyright', 'Copyright Message', 'subfooter_settings_section', 'ThemebeER', 20);
	
	//Header Texts
	$header_address = get_option('do_header_phone', '+00 (123) 456 78 90');
	$header_email = get_option('do_header_email', 'info@themebeer.com');
	
	//Header Layout Option
	$ebor_options->add_setting('select', 'header_layout', 'Global Header Layout', 'header_layout_section', 'do-homepage-one', 5, $header_layouts);
	$ebor_options->add_setting('select', 'header_side_nav', 'Show Side Navigation', 'header_side_navigation', 'yes', 10, $select_options);

	$ebor_options->add_setting('input', 'do_header_phone', 'Top Header Phone No.', 'sub_header_layout_section', '+00 (123) 456 78 90');
	$ebor_options->add_setting('input', 'do_header_email', 'Top Header Email', 'sub_header_layout_section', 'info@themebeer.com', 25);


	//Footer Layouts
	$ebor_options->add_setting('select', 'footer_layout', 'Global Footer Layout', 'footer_layout_section', 'widgets', 5);

	//Footer Icons
	for( $i = 1; $i < 6; $i++ ){
		$ebor_options->add_setting('select', 'footer_social_icon_' . $i, 'Footer Social Icon ' . $i, 'footer_social_settings_section', 'none', 20 + $i + $i, $new_social_options);
		$ebor_options->add_setting('input', 'footer_social_url_' . $i, 'Footer Social URL ' . $i, 'footer_social_settings_section', '', 21 + $i + $i);
	}
	
	//Header icons
	for( $i = 1; $i < 6; $i++ ){
		$ebor_options->add_setting('select', 'header_social_icon_' . $i, 'Header Social Icon ' . $i, 'sub_header_layout_section', 'none', 30 + $i + $i, $new_social_options);
		$ebor_options->add_setting('input', 'header_social_url_' . $i, 'Header Social URL ' . $i, 'sub_header_layout_section', '', 31 + $i + $i);
	}




}