<?php 

/**
 * WordPress' missing is_blog_page() function.  Determines if the currently viewed page is
 * one of the blog pages, including the blog home page, archive, category/tag, author, or single
 * post pages.
 *
 * @see http://core.trac.wordpress.org/browser/tags/3.4.1/wp-includes/query.php#L1572
 *
 * @return bool
 */


/**
 * Post Formats
 * @package do
 * @since v1.0.0
 * @author Jewel Theme
 */

if(!( function_exists('ebor_is_blog_page') )){
	function ebor_is_blog_page() {
	    global $post;
	    return ( ( is_home() || is_archive() || is_single() ) && ('post' == get_post_type($post)) ) ? true : false ;
	}
}

if(!( function_exists('ebor_allowed_tags') )){ 
	function ebor_allowed_tags(){
		return array(
		    'a' => array(
		        'href' => array(),
		        'title' => array(),
		        'class' => array(),
		        'target' => array()
		    ),
		    'br' => array(),
		    'em' => array(),
		    'strong' => array(),
		    'p' => array(
		    	'class' => array()
		    ),
		);	
	}
}

function ebor_page_title($title = false, $subtitle = false){
	$output = '
		<section class="do-normal-page-title-section">
		    <div class="container">
		        <div class="row uppercase">
		
		            <div class="do-page-title-wrapper">
		            	<div class="do-default-page-title col-md-7 col-sm-7 col-xs-12">
		            		<h2>'. $title .'</h2>
		            		<p>'. $subtitle .'</p>
		            	</div>
		
		            	'. ebor_breadcrumbs() .'
		            </div>
		
		        </div>
		    </div>
		</section>
	';	
	
	if( false == $title )
		$output = false;
	
	return $output;
}

if(!( function_exists('ebor_breadcrumbs') )){ 
	function ebor_breadcrumbs() {
		if ( is_front_page() || is_search() ) {
			return;
		}
		global $post;
		$ancestors = array_reverse( get_post_ancestors( $post->ID ) );
		$before = '<div class="do-breadcumb"><ul>';
		$after = '</ul></div>';
		$home = '<li><a href="' . esc_url( home_url( "/" ) ) . '" class="home-link" rel="home">' . esc_html__( 'Home', 'do' ) . '</a></li>';
		
		if( 'portfolio' == get_post_type() ){
			$home .= '<li><a href="' . esc_url( home_url( "/portfolio/" ) ) . '">' . esc_html__( 'Portfolio', 'do' ) . '</a></li>';
		}
		
		if( 'team' == get_post_type() ){
			$home .= '<li><a href="' . esc_url( home_url( "/team/" ) ) . '">' . esc_html__( 'Team', 'do' ) . '</a></li>';
		}
		
		$breadcrumb = '';
		if ( $ancestors ) {
			foreach ( $ancestors as $ancestor ) {
				$breadcrumb .= '<li><a href="' . esc_url( get_permalink( $ancestor ) ) . '">' . esc_html( get_the_title( $ancestor ) ) . '</a></li>';
			}
		}
		
		if( ebor_is_blog_page() ){
			$breadcrumb .= '<li class="active"><span>' . esc_html( get_option('blog_title','Our Blog') ) . '</span></li>';
		} elseif( is_post_type_archive('product') ){
			//nothing
		} else {
			$breadcrumb .= '<li class="active"><span>' . esc_html( get_the_title( $post->ID ) ) . '</span></li>';
		}
		
		return $before . $home . $breadcrumb . $after;
	}
}



if(!( function_exists('ebor_get_portfolio_style') )){
	function ebor_get_portfolio_style(){
		return array(
			esc_html__( 'Default', 'do' ) 		=> '',
			esc_html__( 'Double Height', 'do' ) => 'do-height-dbl',
			esc_html__( 'Double Width', 'do' ) 	=> 'do-width-dbl'
		);	
	}
}

if(!( function_exists('ebor_get_team_layouts') )){
	function ebor_get_team_layouts(){
		return array(
			esc_html__( 'Team Grid', 'do' ) 							=> 'grid',
			esc_html__( 'Small Team Grid (4 Column)', 'do' ) 			=> 'grid-small',
			esc_html__( 'Extra Small Team Grid (3 Column)', 'do' ) 		=> 'grid-extra-small',
			esc_html__( 'FullWidth Team', 'do' ) 						=> 'full',
			esc_html__( 'Team Feed', 'do' ) 							=> 'feed',
			esc_html__( 'Boxed Team', 'do' ) 							=> 'box'
		);
	}
}


/**
 * Returns an array of all available header layouts
 * @package do
 * @author Jewel Theme
 */
if(!( function_exists('ebor_get_header_options') )){
	function ebor_get_header_options(){
		$options = array(
			'do-homepage-one' 			=> esc_html__( 'Default Header', 'do' ),
			'do-homepage-fourth' 		=> esc_html__( 'Top Bar Header', 'do' ),
			'do-homepage-2nd' 			=> esc_html__( 'Transparent Header', 'do' ),
			'none' 						=> esc_html__( 'No Page Title', 'do' ),
		);
		return $options;	
	}
}

/**
 * Returns an array of all available page title layout options
 * 
 * @package do
 * @since v1.0.0
 * @author Jewel Theme
 */
if(!( function_exists('ebor_get_page_title_options') )){
	function ebor_get_page_title_options(){
		return array(
			esc_html__( 'White Background, Default Header', 'do' )                    => 'do-homepage-one',
			esc_html__( 'Social, Utility Top Bar Header', 'do' )                  	  => 'do-homepage-fourth',
			esc_html__( 'Transparent Header', 'do' )                   				  => 'do-homepage-2nd',
			esc_html__( 'No Page Title', 'do' )                                       => 'none'
		);	
	}
}

/**
 * ebor_get_header_layout
 * 
 * Use to conditionally check the page header meta layout against the theme option for the same
 * In short, this function can override the global header option on a post by post basis
 * Call within get_header() for this to override the global header choice
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_get_header_layout') )){
	function ebor_get_header_layout(){
		global $post;
		
		if( is_search() || !( isset($post->ID) ) )
			return get_option('header_layout', 'do-homepage-one');
		
		$header = get_post_meta($post->ID, '_ebor_header_override', 1);
		if( '' == $header || false == $header || 'none' == $header ){
			$header = get_option('header_layout', 'do-homepage-one');
		}
		
		return $header;	
	}
}



/**
 * Portfolio Unlimited
 * Uses pre_get_posts to provide unlimited portfolio posts when viewing the /portfolio/ archive
 * @since 1.0.0
 */
if(!(function_exists( 'ebor_portfolio_unlimited' ))){
	function ebor_portfolio_unlimited( $query ) {
	    if ( 
	    	is_post_type_archive('portfolio') && !( is_admin() ) && $query->is_main_query() ||
	    	is_tax('portfolio_category') && !( is_admin() ) && $query->is_main_query()
	    ) {
	        $query->set( 'posts_per_page', '-1' );
	    }    
	    return;
	}
	add_action( 'pre_get_posts', 'ebor_portfolio_unlimited' );
}

/**
 * Init theme options
 * Certain theme options need to be written to the database as soon as the theme is installed.
 * This is either for the enqueues in ebor-framework, or to override the default image sizes in WooCommerce.
 * Either way this function is only called when the theme is first activated, de-activating and re-activating the theme will result in these options returning to defaults.
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_init_theme_options') )){
	/**
	 * Hook in on activation
	 */
	global $pagenow;
	
	/**
	 * Define image sizes
	 */
	function ebor_init_theme_options() {
		//Ebor Framework
		$framework_args = array(
			'portfolio_post_type'   => '1',
			'team_post_type'        => '1',
			'client_post_type'      => '1',
			'testimonial_post_type' => '1',
			'mega_menu'             => '0',
			'aq_resizer'            => '0',
			'page_builder'          => '0',
			'likes'                 => '0',
			'options'               => '1',
			'metaboxes'             => '1',
			'pivot_shortcodes'      => '0',
			'do_shortcodes'    		=> '0',
			'do_widgets'       		=> '0'
		);
		update_option('ebor_framework_options', $framework_args);
	}
	
	/**
	 * Only call this action when we first activate the theme.
	 */
	if ( 
		is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ||
		is_admin() && isset( $_GET['theme'] ) && $pagenow == 'customize.php'
	){
		add_action( 'init', 'ebor_init_theme_options', 1 );
	}
}

/**
 * Register the required plugins for this theme.
 * 
 * @since v1.0.0
 * @package Do
 * @author Jewel Theme
 */
if(!( function_exists('ebor_register_required_plugins') )){
	function ebor_register_required_plugins() {
		$plugins = array(
			array(
			    'name'      			=> esc_html__( 'Contact Form 7', 'do' ),
			    'slug'      			=> esc_html__( 'contact-form-7', 'do' ),
			    'required'  			=> true,
			    'version' 				=> ''
			),
			array(
				'name'     				=> esc_html__( 'Ebor Framework', 'do' ),
				'slug'     				=> esc_html__( 'Ebor-Framework-master', 'do' ),
				'source'   				=> esc_url_raw( 'http://demos.jeweltheme.com/plugin-downloads/Ebor-Framework-master.zip' ),
				'required' 				=> true,
				'version' 				=> esc_html__( '1.1.3', 'do' )
			),			
			array(
				'name'     				=> esc_html__( 'Envato WordPress Toolkit', 'do' ),
				'slug'     				=> esc_html__( 'envato-wordpress-toolkit', 'do' ),
				'source'   				=> esc_url_raw( 'https://github.com/envato/envato-wordpress-toolkit/archive/master.zip' ),
				'required' 				=> true,
				'version' 				=> esc_html__( '1.7.3', 'do' )
			),
			array(
				'name'     				=> esc_html__( 'Visual Composer', 'do' ),
				'slug'     				=> esc_html__( 'js_composer', 'do' ),
				'source'   				=> esc_url_raw( 'http://demos.jeweltheme.com/plugin-downloads/js_composer.zip' ),
				'required' 				=> true,
				'version' 			 	=> '4.12',
			),
			array(
				'name'     				=> esc_html__( 'Revolution Slider', 'do' ),
				'slug'     				=> esc_html__( 'revslider', 'do' ),
				'source'   				=> esc_url_raw( 'http://demos.jeweltheme.com/plugin-downloads/revslider.zip' ),
				'required' 				=> true,
				'version' 			 	=> '5.2.5.3',
			)
		);
		$config = array(
			'is_automatic' => true,
		);
		tgmpa( $plugins, $config );
	}
	add_action( 'tgmpa_register', 'ebor_register_required_plugins' );
}


/**
 * Returns custom Pagination
 * @author Jewel Theme
 * @since v1.0.0
 */

if(!( function_exists('ebor_pagination') )){
	function ebor_pagination($pages = '', $range = 2){
		$showitems = ($range * 1)+1;
		
		global $paged;
		if(empty($paged)) $paged = 1;
		
		if($pages == ''){
			global $wp_query;
			$pages = $wp_query->max_num_pages;
				if(!$pages) {
					$pages = 1;
				}
		}
		
		$output = '';
			
		if(1 != $pages){
			$output .= "<div class='text-center'><ul class='pagination'>";

			if($paged > 2 && $showitems < $pages){ 
				echo '<a href="' . previous_posts_link("") . '" class="prev page-numbers pull-left" ><i class="fa fa-chevron-left"></i></a>';
			}


			for ($i=1; $i <= $pages; $i++){
				if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )){
					$output .= ($paged == $i)? "<li class='active'><a href='".get_pagenum_link($i)."'>".$i."</a></li> ":"<li><a href='".get_pagenum_link($i)."'>".$i."</a></li> ";
				}
			}
		

            if ($paged < $pages && $showitems < $pages){
             	echo '<a href="' . next_posts_link("") . '" class="next page-numbers pull-right"><i class="fa fa-chevron-right"></i></a>';
            }

			$output.= "</ul></div>";
		}
		
		return $output;
	}
}


/**
 * Custom Comment Markup for Do
 * 
 * @since v1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_custom_comment') )){
	function ebor_custom_comment($comment, $args, $depth) { 
		$GLOBALS['comment'] = $comment; 
	?>
		
		<div <?php comment_class('do-blog-comments'); ?> id="comment-<?php comment_ID() ?>">
		    <div class="do-user-img">
		        <?php echo get_avatar( $comment->comment_author_email, 75 ); ?>
		    </div>
		
		    <div class="do-comments">
		        <div class="do-comments-title">
		            <?php printf('<h4 class="do-user-name">%s %s</h4>', get_comment_author_link(), esc_html__('SAYS:','do')); ?>
		            <span class="do-comment-date-time"><?php echo get_comment_date(); ?></span>
		        </div>
		
		        <?php echo wpautop( htmlspecialchars_decode( get_comment_text() ) ); ?>
		        <?php if ($comment->comment_approved == '0') : ?>
		        <p><em><?php esc_html__('Your comment is awaiting moderation.', 'do') ?></em></p>
		        <?php endif; ?>	
		    </div>
		
		    <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
		 </div>
	
	<?php }
}


/**
* Returns Custom Post Types with Order and Limit
* @package do
* @since v1.0.0
* @author Jewel Theme
*/
function ebor_get_custom_posts($type, $limit = 20, $order = "DESC") {
    wp_reset_postdata();
    $args = array(
        "posts_per_page" => $limit,
        "post_type" => $type,
        "orderby" => "ID",
        "order" => $order,
    );
    $custom_posts = get_posts($args);
    return $custom_posts;
}



/**
* Returns Admin Notification Style alignment
 * @package do
 * @since v1.0.0
 * @author Jewel Theme
*/
add_action('admin_head', 'ebor_do_custom_admin_notice_css');
function ebor_do_custom_admin_notice_css() {
  echo '<style>
	  .wp-core-ui .notice.is-dismissible {
	  	float: none;
	  	display: block;
	  }
  </style>';
}



/**
 * Custom Header Image
 * @package do
 * @since v1.0.0
 * @author Jewel Theme
 */
function ebor_do_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'do_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => '000000',
		'width'                  => 1000,
		'height'                 => 250,
		'flex-height'            => true,
		'admin-head-callback'    => 'do_admin_header_style',
		'admin-preview-callback' => 'do_admin_header_image',
	) ) );
}
add_action( 'after_setup_theme', 'ebor_do_custom_header_setup' );



function ebor_do_custom_style(){ 
	$preloader_logo = get_option('preloader_logo', EBOR_THEME_DIRECTORY . 'style/images/controls/preloader-logo.png');
	?>	
	<style type="text/css">
	    .do-loader {
	    	background-image: url( "<?php echo esc_url($preloader_logo); ?>");
	    }  
	</style>
<?php 

}
add_action( 'wp_head', 'ebor_do_custom_style');