<?php 

remove_filter( 'wp_title', 'ebor_framework_wp_title', 10, 2 );

if(!( function_exists('ebor_remove_more_link_scroll') )){ 
	function ebor_remove_more_link_scroll( $link ) {
		$link = preg_replace( '|#more-[0-9]+|', '', $link );
		return $link;
	}
	add_filter( 'the_content_more_link', 'ebor_remove_more_link_scroll' );
}

/**
 * Force easy google fonts plugin styles
 */
if(!( function_exists('ebor_egf_force_styles') )){ 
	function ebor_egf_force_styles( $force_styles ) {
	    return true;
	}
	add_filter( 'tt_font_force_styles', 'ebor_egf_force_styles' );
}

/**
 * Add a clearfix to the end of the_content()
 */
if(!( function_exists('ebor_add_clearfix') )){ 
	function ebor_add_clearfix( $content ) { 
		if( is_single() )
	   		$content = $content .= '<div class="clearfix"></div>';
	    return $content;
	}
	add_filter( 'the_content', 'ebor_add_clearfix' ); 
}

/**
 * Control default more
 */
if(!( function_exists('ebor_excerpt_more') )){
	function ebor_excerpt_more( $more ) {
		return '...';
	}
	add_filter('excerpt_more', 'ebor_excerpt_more');
}

/**
 * Control default excerpt length.
 */
if(!( function_exists('ebor_excerpt_length') )){
	function ebor_excerpt_length( $length ) {
		return 21;
	}
	add_filter( 'excerpt_length', 'ebor_excerpt_length', 999 );
}

/**
 * Remove leading whitespace from the_excerpt
 */
if(!( function_exists('ebor_ltrim_excerpt') )){
	function ebor_ltrim_excerpt( $excerpt ) {
	    return preg_replace( '~^(\s*(?:&nbsp;)?)*~i', '', $excerpt );
	}
	add_filter( 'get_the_excerpt', 'ebor_ltrim_excerpt' );
}

/**
 * Filter the tag cloud appearance to match Tucson styling
 */
if(!( function_exists('ebor_tag_cloud') )){
	function ebor_tag_cloud($tag_string){
		$tag_string = preg_replace("/style='font-size:.+pt;'/", '', $tag_string);
		return $tag_string;
	}
	add_filter('wp_generate_tag_cloud', 'ebor_tag_cloud',10,3);
}

function ebor_the_author_posts_link($link){
    if( is_single() ){
    	return str_replace( 'rel="author"', 'rel="author" class="do-blog-post-author"', $link );
    } else {
    	return str_replace( 'rel="author"', 'rel="author" class="do-author"', $link );	
    }
};
add_filter( 'the_author_posts_link', 'ebor_the_author_posts_link');

/**
 * Add classes to portfolio post nav
 */
if(!( function_exists('ebor_prev_post_link_attributes') )){ 
	function ebor_prev_post_link_attributes($output) {
	    $class = 'class="do-prev-portfolio-work"';
	    return str_replace('<a href=', '<a '.$class.' href=', $output);
	}
	add_filter('previous_post_link', 'ebor_prev_post_link_attributes');
}

/**
 * Add classes to portfolio post nav
 */
if(!( function_exists('ebor_next_post_link_attributes') )){ 
	function ebor_next_post_link_attributes($output) {
	    $class = 'class="do-next-portfolio-work"';
	    return str_replace('<a href=', '<a '.$class.' href=', $output);
	}
	add_filter('next_post_link', 'ebor_next_post_link_attributes');
}