'use strict';

function SGPBGutenbergBlock() {}

SGPBGutenbergBlock.prototype.init = function () {
    var localizedParams = SGPB_GUTENBERG_PARAMS;

    var __ = wp.i18n;
    var createElement = wp.element.createElement;
    var registerBlockType = wp.blocks.registerBlockType;
    var InspectorControls = wp.editor.InspectorControls;
    var _wp$components = wp.components,
        SelectControl = _wp$components.SelectControl,
        TextareaControl = _wp$components.TextareaControl,
        ToggleControl = _wp$components.ToggleControl,
        PanelBody = _wp$components.PanelBody,
        ServerSideRender = _wp$components.ServerSideRender,
        Placeholder = _wp$components.Placeholder;

    registerBlockType('popupbuilder/popups', {
        title: localizedParams.title,
        description: localizedParams.description,
        keywords: ['popup', 'popup-builder'],
        category: 'widgets',
        icon: 'welcome-widgets-menus',
        attributes: {
            popupId: {
                type: 'number'
            },
            popupEvent: {
                type: 'string'
            }
        },
        edit: function edit(props) {
            var _props$attributes = props.attributes,
                _props$attributes$pop = _props$attributes.popupId,
                popupId = _props$attributes$pop === undefined ? '' : _props$attributes$pop,
                _props$attributes$dis = _props$attributes.displayTitle,
                displayTitle = _props$attributes$dis === undefined ? false : _props$attributes$dis,
                _props$attributes$dis2 = _props$attributes.displayDesc,
                displayDesc = _props$attributes$dis2 === undefined ? false : _props$attributes$dis2,
                _props$attributes$pop2 = _props$attributes.popupEvent,
                popupEvent = _props$attributes$pop2 === undefined ? '' : _props$attributes$pop2,
                setAttributes = props.setAttributes;

            var formOptions = SGPB_GUTENBERG_PARAMS.allPopups.map(function (value) {
                return {
                    value: value.id,
                    label: value.title
                };
            });
            var eventsOptions = SGPB_GUTENBERG_PARAMS.allEvents.map(function (value) {
                return {
                    value: value.value,
                    label: value.title
                };
            });
            var jsx = void 0;

            formOptions.unshift({
                value: '',
                label: SGPB_GUTENBERG_PARAMS.i18n.form_select
            });

            function selectPopup(value) {
                setAttributes({
                    popupId: value
                });
            }

            function selectEvent(value) {
                setAttributes({
                    popupEvent: value
                });
            }

            function setContent(value) {
                setAttributes({
                    content: value
                });
            }

            function toggleDisplayTitle(value) {
                setAttributes({
                    displayTitle: value
                });
            }

            function toggleDisplayDesc(value) {
                setAttributes({
                    displayDesc: value
                });
            }

            jsx = [React.createElement(
                InspectorControls,
                { key: 'popuopbuilder-gutenberg-form-selector-inspector-controls' },
                React.createElement(
                    PanelBody,
                    { title: 'popup builder title' },
                    React.createElement(SelectControl, {
                        label: SGPB_GUTENBERG_PARAMS.i18n.form_selected,
                        value: popupId,
                        options: formOptions,
                        onChange: selectPopup
                    }),
                    React.createElement(SelectControl, {
                        label: SGPB_GUTENBERG_PARAMS.i18n.form_selected,
                        value: popupId,
                        options: eventsOptions,
                        onChange: selectEvent
                    }),
                    React.createElement(ToggleControl, {
                        label: SGPB_GUTENBERG_PARAMS.i18n.show_title,
                        checked: displayTitle,
                        onChange: toggleDisplayTitle
                    }),
                    React.createElement(ToggleControl, {
                        label: SGPB_GUTENBERG_PARAMS.i18n.show_description,
                        checked: displayDesc,
                        onChange: toggleDisplayDesc
                    })
                )
            )];

            if (popupId && popupEvent) {
                var clickText = '';
                if (popupEvent == 'click') {
                    clickText = 'click me';
                }
                return '[sg_popup id="' + popupId + '" event="' + popupEvent + '"]' + clickText + '[/sg_popup]';
            } else {
                jsx.push(React.createElement(
                    Placeholder,
                    {
                        key: 'sgpb-gutenberg-form-selector-wrap',
                        className: 'sgpb-gutenberg-form-selector-wrapper'},
                    React.createElement('img', { 'class': SGPB_GUTENBERG_PARAMS.logo_classname, src: SGPB_GUTENBERG_PARAMS.logo_url }),
                    React.createElement(SelectControl, {
                        key: 'sgpb-gutenberg-form-selector-select-control',
                        value: popupId,
                        options: formOptions,
                        onChange: selectPopup
                    }),
                    React.createElement(SelectControl, {
                        key: 'sgpb-gutenberg-form-selector-select-control',
                        value: popupEvent,
                        options: eventsOptions,
                        onChange: selectEvent
                    })
                ));
            }

            return jsx;
        },
        save: function save(props) {
            var clickText = '';
            if (props.attributes.popupEvent == 'click') {
                clickText = SGPB_GUTENBERG_PARAMS.clickText;
            }

            return '[sg_popup id="' + props.attributes.popupId + '" event="' + props.attributes.popupEvent + '"]' + clickText + '[/sg_popup]';
        }
    });
};

jQuery(document).ready(function () {
    if (typeof wp != 'undefined' && typeof wp.element != 'undefined' && typeof wp.blocks != 'undefined' && typeof wp.editor != 'undefined' && typeof wp.components != 'undefined') {
        var block = new SGPBGutenbergBlock();
        block.init();
    }
});
