<?php 

/**
 * The Shortcode
 */
function ebor_service_box_shortcode( $atts, $content = null ) {
	extract( 
		shortcode_atts( 
			array(
				'title' => 'Design',
				'icon' => 'icon-trophy',
				'front_color' => '#ffc000',
				'hover_color' => '#474747',
			), $atts 
		) 
	);
	
	$output = '
		<div class="do-service-container">
		    <div class="do-service-container-inner">
		    
		        <div class="do-front-part" style="background-color:'. esc_attr($front_color) .'">
		            <div class="do-front-content">
		                <i class="'. esc_attr($icon) .'"></i>
		                <h3>'. strip_tags(trim($title)) .'</h3>
		            </div>
		        </div>
		
		        <div class="do-back-part" style="background-color:'. esc_attr($hover_color) .'">
		            <div class="do-back-content">
		                '. wpb_js_remove_wpautop(do_shortcode(htmlspecialchars_decode($content))) .'
		            </div>
		        </div>
		        
		    </div>
		</div>
	';
	
	return $output;
}
add_shortcode( 'do_service_box', 'ebor_service_box_shortcode' );

/**
 * The VC Functions
 */
function ebor_service_box_shortcode_vc() {
	
	$icons = ebor_get_icons();
	
	vc_map( 
		array(
			"icon" => 'do-vc-block',
			"name" => __("Service Box", 'do'),
			"base" => "do_service_box",
			"category" => __('do WP Theme', 'do'),
			"params" => array(
				array(
					"type" => "ebor_icons",
					"heading" => __("Click an Icon to choose", 'do'),
					"param_name" => "icon",
					"value" => $icons,
					'description' => 'Type "none" or leave blank to hide icons.'
				),
				array(
					"type" => "textfield",
					"heading" => __("Title", 'do'),
					"param_name" => "title",
					'holder' => 'div',
				),
				array(
					"type" => "textarea_html",
					"heading" => __("Block Content", 'do'),
					"param_name" => "content",
					'holder' => 'div'
				),				
				array(
					"type" => "colorpicker",
					"heading" => __("Front Color", 'do'),
					"param_name" => "front_color",
				),				
				array(
					"type" => "colorpicker",
					"heading" => __("Back Color", 'do'),
					"param_name" => "hover_color",
				),
			)
		) 
	);
}
add_action( 'vc_before_init', 'ebor_service_box_shortcode_vc' );