<?php 

/**
 * The Shortcode
 */
function ebor_page_alt_title_shortcode( $atts, $content = null ) {
	extract( 
		shortcode_atts( 
			array(
				'title' => '',
				'subtitle' => ''
			), $atts 
		) 
	);
	
	$output = '
		<div class="do-page-title">
		    <h1 class="uppercase">'. strip_tags(trim($title)) .'</h1>
		    <p class="uppercase">'. strip_tags(trim($subtitle)) .'</p>
		</div>
	';
	
	return $output;
}
add_shortcode( 'do_page_alt_title', 'ebor_page_alt_title_shortcode' );

/**
 * The VC Functions
 */
function ebor_page_alt_title_shortcode_vc() {
	vc_map( 
		array(
			"icon" => 'do-vc-block',
			"name" => __("Alt Page Title", 'do'),
			"base" => "do_page_alt_title",
			"category" => __('do WP Theme', 'do'),
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => __("Title", 'do'),
					"param_name" => "title",
					'holder' => 'div',
				),
				array(
					"type" => "textfield",
					"heading" => __("Subtitle", 'do'),
					"param_name" => "subtitle",
				)
			)
		) 
	);
}
add_action( 'vc_before_init', 'ebor_page_alt_title_shortcode_vc' );