<?php 

/**
 * The Shortcode
 */
function ebor_icon_box_shortcode( $atts, $content = null ) {
	extract( 
		shortcode_atts( 
			array(
				'title' => '0.3s',
				'icon' => '',
				'type' => 'do-icon-with-text-style1'
			), $atts 
		) 
	);
	
	$output = '
		<div class="'. esc_attr($type) .' appear fadeIn" data-wow-duration="1s" data-wow-delay="'. esc_attr($title) .'">
		    <div class="do-icon-wrapper">
		        <i class="'. esc_attr($icon) .'"></i>
		    </div>
		    '. wpautop(do_shortcode(htmlspecialchars_decode($content))) .'
		</div>
	';
	
	return $output;
}
add_shortcode( 'do_icon_box', 'ebor_icon_box_shortcode' );

/**
 * The VC Functions
 */
function ebor_icon_box_shortcode_vc() {
	
	$icons = ebor_get_icons();
	
	$types = array(
		'Colours' => 'do-icon-with-text-style1',
		'Colour on Hover' => 'do-icon-with-text-style3'
	);
	
	vc_map( 
		array(
			"icon" => 'do-vc-block',
			"name" => __("Icon Box", 'do'),
			"base" => "do_icon_box",
			"category" => __('do WP Theme', 'do'),
			"params" => array(
				array(
					"type" => "ebor_icons",
					"heading" => __("Click an Icon to choose", 'do'),
					"param_name" => "icon",
					"value" => $icons,
					'description' => 'Type "none" or leave blank to hide icons.'
				),
				array(
					"type" => "textarea_html",
					"heading" => __("Block Content", 'do'),
					"param_name" => "content",
					'holder' => 'div'
				),
				array(
					"type" => "textfield",
					"heading" => __("Animation Delay", 'do'),
					"param_name" => "title",
					'value' => '0.3s',
				),
				array(
					"type" => "dropdown",
					"heading" => __("Display type", 'do'),
					"param_name" => "type",
					"value" => $types
				),
			)
		) 
	);
}
add_action( 'vc_before_init', 'ebor_icon_box_shortcode_vc' );