<?php 

/**
 * The Shortcode
 */
function ebor_counter_shortcode( $atts, $content = null ) {
	extract( 
		shortcode_atts( 
			array(
				'title' => '',
				'icon' => '',
				'from' => '',
				'to' => '',
				'type' => 'colour'
			), $atts 
		) 
	);
	
	if( 'colour' == $type ){
		
		$output = '
			<div class="do-counter-section">
			    <div class="do-counter-items">
			        <i class="'. esc_attr($icon) .'"></i>
			        <h3 class="do-counter" data-from="'. $from .'" data-to="'. $to .'">'. $from .'</h3>
			        <span>'. esc_attr($title) .'</span>
			    </div>
			</div>
		';
	
	} elseif( 'black' == $type ) {
	
		$output = '
			<div class="do-counter-section-2 black">
			    <div class="do-counter-items">
			        <div class="do-counter-items-inner">
			            <div class="do-number-icon">
			                <i class="'. esc_attr($icon) .'"></i>
			                <h3 class="do-counter" data-from="'. $from .'" data-to="'. $to .'">'. $from .'</h3>
			            </div>
			            <span>'. esc_attr($title) .'</span>
			        </div>
			    </div>
			</div>
		';
	
	} else {
	
		$output = '
			<div class="do-counter-section-2">
			    <div class="do-counter-items">
			        <div class="do-counter-items-inner">
			            <div class="do-number-icon">
			                <i class="'. esc_attr($icon) .'"></i>
			                <h3 class="do-counter" data-from="'. $from .'" data-to="'. $to .'">'. $from .'</h3>
			            </div>
			            <span>'. esc_attr($title) .'</span>
			        </div>
			    </div>
			</div>
		';
	
	}
	
	return $output;
}
add_shortcode( 'do_counter', 'ebor_counter_shortcode' );

/**
 * The VC Functions
 */
function ebor_counter_shortcode_vc() {
	
	$icons = ebor_get_icons();
	
	$types = array(
		'Colour' => 'colour',
		'White' => 'white',
		'Black' => 'black'
	);
	
	vc_map( 
		array(
			"icon" => 'do-vc-block',
			"name" => __("Counter", 'do'),
			"base" => "do_counter",
			"category" => __('do WP Theme', 'do'),
			"params" => array(
				array(
					"type" => "ebor_icons",
					"heading" => __("Click an Icon to choose", 'do'),
					"param_name" => "icon",
					"value" => $icons,
					'description' => 'Type "none" or leave blank to hide icons.'
				),
				array(
					"type" => "textfield",
					"heading" => __("Title", 'do'),
					"param_name" => "title",
					'holder' => 'div'
				),
				array(
					"type" => "textfield",
					"heading" => __("Counter From Value", 'do'),
					"param_name" => "from"
				),
				array(
					"type" => "textfield",
					"heading" => __("Counter To Value", 'do'),
					"param_name" => "to"
				),
				array(
					"type" => "dropdown",
					"heading" => __("Display type", 'do'),
					"param_name" => "type",
					"value" => $types
				),
			)
		) 
	);
}
add_action( 'vc_before_init', 'ebor_counter_shortcode_vc' );