<?php 

/**
 * The Shortcode
 */
function ebor_blog_shortcode( $atts ) {
	extract( 
		shortcode_atts( 
			array(
				'type' => 'strip',
				'pppage' => '6',
				'pagination' => 'yes',
				'filter' => 'all'
			), $atts 
		) 
	);
	
	// Fix for pagination
	if( is_front_page() ) { 
		$paged = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1; 
	} else { 
		$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1; 
	}
	
	/**
	 * Setup post query
	 */
	$query_args = array(
		'post_type' => 'post',
		'posts_per_page' => $pppage,
		'paged' => $paged
	);
	
	if (!( $filter == 'all' )) {
		if( function_exists( 'icl_object_id' ) ){
			$filter = (int)icl_object_id( $filter, 'category', true);
		}
		$query_args['tax_query'] = array(
			array(
				'taxonomy' => 'category',
				'field' => 'id',
				'terms' => $filter
			)
		);
	}

	$block_query = new WP_Query( $query_args );

	ob_start();
?>
		
	<?php if( $type == 'masonry' ) : ?>
		
		<div class="row">
		
			<div class="do-masonry-blog-wrapper col-md-8 col-sm-8 col-xs-12">
			    <?php 
			    	if ( $block_query->have_posts() ) : while ( $block_query->have_posts() ) : $block_query->the_post();
			    		
			    		/**
			    		 * Get blog posts by blog layout.
			    		 */
			    		get_template_part('loop/content-post', 'masonry');
			    	
			    	endwhile;	
			    	else : 
			    		
			    		/**
			    		 * Display no posts message if none are found.
			    		 */
			    		get_template_part('loop/content','none');
			    		
			    	endif;
			    ?>
			</div>
			
			<?php get_sidebar(); ?>
		
		</div>
		
		<?php
			if( 'yes' == $pagination ){
				/**
				* Post pagination, use ebor_pagination() first and fall back to default
				*/
				echo function_exists('ebor_pagination') ? ebor_pagination($block_query->max_num_pages) : posts_nav_link();
			}
		?>
		
	<?php elseif( $type == 'masonry-no-sidebar' ) : ?>
	
		<div class="row">
		
			<div class="do-masonry-blog-wrapper no-sidebar col-sm-12">
			    <?php 
			    	if ( $block_query->have_posts() ) : while ( $block_query->have_posts() ) : $block_query->the_post();
			    		
			    		/**
			    		 * Get blog posts by blog layout.
			    		 */
			    		get_template_part('loop/content-post', 'masonry');
			    	
			    	endwhile;	
			    	else : 
			    		
			    		/**
			    		 * Display no posts message if none are found.
			    		 */
			    		get_template_part('loop/content','none');
			    		
			    	endif;
			    ?>
			</div>
			
			<?php
				if( 'yes' == $pagination ){
					/**
					* Post pagination, use ebor_pagination() first and fall back to default
					*/
					echo function_exists('ebor_pagination') ? ebor_pagination($block_query->max_num_pages) : posts_nav_link();
				}
			?>
			
		</div>
		
	<?php else : ?>
	
		<div class="row">
			<div class="do-blog-items-wrapper do-infinite-blog">
			
			    <?php 
			    	if ( $block_query->have_posts() ) : while ( $block_query->have_posts() ) : $block_query->the_post();
			    		
			    		/**
			    		 * Get blog posts by blog layout.
			    		 */
			    		get_template_part('loop/content-post', 'strip');
			    	
			    	endwhile;	
			    	else : 
			    		
			    		/**
			    		 * Display no posts message if none are found.
			    		 */
			    		get_template_part('loop/content','none');
			    		
			    	endif;
			    ?>
			
			    <?php
			    	if( 'yes' == $pagination ){
			    		/**
			    		* Post pagination, use ebor_pagination() first and fall back to default
			    		*/
			    		echo function_exists('ebor_pagination') ? ebor_pagination($block_query->max_num_pages) : posts_nav_link();
			    	}
			    ?>
			    
			</div>
		</div>
		
	<?php endif; ?>
			
<?php	
	wp_reset_postdata();
	
	$output = ob_get_contents();
	ob_end_clean();
	
	return $output;
}
add_shortcode( 'do_blog', 'ebor_blog_shortcode' );

/**
 * The VC Functions
 */
function ebor_blog_shortcode_vc() {
	
	$blog_types = ebor_get_blog_layouts();
	
	vc_map( 
		array(
			"icon" => 'do-vc-block',
			"name" => __("Blog Feeds", 'do'),
			"base" => "do_blog",
			"category" => __('do WP Theme', 'do'),
			'description' => 'Show blog posts with layout options.',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => __("Show How Many Posts?", 'do'),
					"param_name" => "pppage",
					"value" => '8'
				),
				array(
					"type" => "dropdown",
					"heading" => __("Display type", 'do'),
					"param_name" => "type",
					"value" => $blog_types
				),
				array(
					"type" => "dropdown",
					"heading" => __("Show Pagination?", 'do'),
					"param_name" => "pagination",
					"value" => array(
						'Yes' => 'yes',
						'No' => 'no'
					),
				),
			)
		) 
	);
	
}
add_action( 'vc_before_init', 'ebor_blog_shortcode_vc');