<?php
/**
 * WPLMS MODERN functions and actions.
 *
 * @author 		VibeThemes
 * @category 	Admin
 * @package 	Vibe Projects/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Wplms_Modern_Init{


	public static $instance;
    
    public static function init(){
    	
        if ( is_null( self::$instance ) )
            self::$instance = new Wplms_Modern_Init();
        return self::$instance;
    }

	private function __construct(){
		add_action('wp_footer',array($this,'login_modal'));
		add_action('wp_enqueue_scripts',array($this,'load_scripts'));
		add_filter('vibe_builder_thumb_styles',array($this,'custom_vibe_builder_thumb_styles'));  
		add_filter('vibe_featured_thumbnail_style',array($this,'custom_vibe_featured_thumbnail_style'),1,3);
		add_filter('vibe_option_custom_sections',array($this,'wplms_modern_section'));
		add_action('wp_ajax_nopriv_create_user',array($this,'create_user'));
		add_action('wp_ajax_nopriv_forgot_password',array($this,'forgot_password'));
		add_filter('bp_course_single_item_view',array($this,'bp_course_single_item_view'));
		add_action('init',array($this,'init_actions'));
		add_action('widgets_init',array($this,'register_sidebars'));
		add_action('wplms_customizer_custom_css',array($this,'wplms_customizer'),10,1);		
		add_filter('wplms_course_metabox',array($this,'upload_bg'));
		add_filter('vibe_projects_registration_fields',array($this,'registration_code'));
		add_filter('bp_course_display_rating',array($this,'bp_course_display_rating'),10,2);
		add_filter( 'template_include',array($this,'wplms_check_instructing_courses_endpoint'),99,2);

	}

	function init_actions(){
		remove_filter( 'comment_text', 'modify_comment');	
	}

	function load_scripts(){
		wp_enqueue_style( 'wplms-modern-css', get_stylesheet_directory_uri().'/assets/css/wplms_modern.min.css' );
		wp_enqueue_script( 'wplms-modern-js', get_stylesheet_directory_uri().'/assets/js/wplms_modern.min.js');
	}

	function register_sidebars(){
		if(function_exists('register_sidebar')){     
		    register_sidebar( array(
				'name' => 'Member Sidebar',
				'id' => 'member',
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h4 class="widget_title">',
				'after_title' => '</h4>',
		        'description'   => __('Sidebar Displayed on Member profile','vibe')
			) );
			register_sidebar( array(
				'name' => 'Group Sidebar',
				'id' => 'group',
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h4 class="widget_title">',
				'after_title' => '</h4>',
		        'description'   => __('Sidebar Displayed on single Group','vibe')
			) );
		}
	}
	function login_modal(){
	    if(is_user_logged_in())
	      return;

	    include_once get_stylesheet_directory().'/views/login_modal.php';
	}

	function option($ref){
		if(empty($this->option))
			$this->option = get_option(THEME_SHORT_NAME);

		return $this->option[$ref];
	}

	
	function wplms_modern_section($sections){
		$sections[1]['fields'][] = array(
							'id' => 'hero_img',
							'type' => 'upload',
							'title' => __('Upload Default Background image', 'vibe'), 
							'sub_desc' => __('Upload big default background image', 'vibe'),
							'desc' => __('This image is shown in header.', 'vibe'),
	                        'std' => ''
							);
		$sections[1]['fields'][] = array(
							'id' => 'alternate_logo',
							'type' => 'upload',
							'title' => __('Upload Alternate Logo', 'vibe'), 
							'sub_desc' => __('upload alternate logo', 'vibe'),
							'desc' => __('', 'vibe'),
							'std' => ''
							);
		$sections[11]['fields'][] = array(
							'id' => 'disable_ajax_registration',
							'title' => __('Disable Ajax Registration', 'vibe'), 
							'sub_desc' => __('use standard BuddyPress registration', 'vibe'),
							'desc' => __('Enables standard buddypress registration on clicking Create account in login popup', 'vibe'),
							'type' => 'button_set',
							'options' => array('' => __('No, keep enabled','vibe'),1 => __('Yes, disable ajax registration','vibe')),
							'std' => ''
							);
		$sections[11]['fields'][] = array(
							'id' => 'registration_code',
							'type' => 'text',
							'title' => __('Registration Code for Ajax', 'vibe'), 
							'sub_desc' => __('signup registration code', 'vibe'),
							'desc' => __('Enter a registration code for signup, leave blank for default', 'vibe'),
							'std' => ''
							);
		$v_thumb_styles = apply_filters('vibe_builder_thumb_styles',array(
                            ''=> plugins_url('images/thumb_1.png',__FILE__),
                            'course'=> plugins_url('images/thumb_2.png',__FILE__),
                            'course2'=> plugins_url('images/thumb_8.png',__FILE__),
                            'side'=> plugins_url('images/thumb_3.png',__FILE__),
                            'blogpost'=> plugins_url('images/thumb_6.png',__FILE__),
                            'images_only'=> plugins_url('images/thumb_4.png',__FILE__),
                            'testimonial'=> plugins_url('images/thumb_5.png',__FILE__),
                            'event_card'=> plugins_url('images/thumb_7.png',__FILE__),
                                ));
		$options = array_keys($v_thumb_styles);
		$sections[4]['fields'][] = array(
							'id' => 'related_course_style',
							'type' => 'select',
							'options'=>$options,
							'title' => __('Related Course style', 'vibe'), 
							'sub_desc' => __('', 'vibe'),
							'desc' => __('related course block in single course page style', 'vibe'),
							'std' => ''
							);
		return $sections;
	}


	function custom_vibe_builder_thumb_styles($styles){
		$styles['modern1'] =  get_stylesheet_directory_uri().'/assets/images/thumb_modern.png';
		return $styles;
	}

	function custom_vibe_featured_thumbnail_style($thumbnail_html,$post,$style){

		if($style == 'modern1'){ 
			
	        $thumbnail_html ='';
	        $thumbnail_html .= '<div class="block modern_course">';
	        $thumbnail_html .= '<div class="block_media">';
	        $thumbnail_html .= '<a href="'.get_permalink($post->ID).'">'.get_the_post_thumbnail($post->ID,'medium').'</a>';
	        $thumbnail_html .= '</div>';
	        $thumbnail_html .= '<div class="block_content">';
	        $thumbnail_html .= '<h4 class="block_title"><a href="'.get_permalink($post->ID).'" title="'.$post->post_title.'">'.$post->post_title.'</a></h4>';
	        $thumbnail_html .= '<div class="course_price">'.bp_course_get_course_credits().'</div>';
	        $thumbnail_html .= '<a href="'.bp_core_get_user_domain($post->post_author).'" class="modern_course_instructor" 
	        title="'.sprintf(__('Course Author %s','vibe'),bp_core_get_user_displayname($post->post_author )).'">'.
	        bp_core_fetch_avatar(array(
						'item_id' => $post->post_author, 
						'type' => 'thumb', 
						'width' => 64, 
						'height' => 64)).'</a>';

	        $thumbnail_html .= '<div class="course_meta">';
	        $reviews = get_post_meta(get_the_ID(),'average_rating',true);
			$students = get_post_meta(get_the_ID(),'vibe_students',true);
			$thumbnail_html .='<span class="dashicons dashicons-groups">'.$students.'</span> ';
			$thumbnail_html .='<div class="modern-star-rating">';
			for($i=1;$i<=5;$i++){
				if($reviews >= 1){
					$thumbnail_html .= '<span class="dashicons dashicons-star-filled"></span>';
				}elseif(($reviews < 1 ) && ($reviews >= 0.4 ) ){
					$thumbnail_html .= '<span class="dashicons dashicons-star-half"></span>';
				}else{
					$thumbnail_html .= '<span class="dashicons dashicons-star-empty"></span>';
				}
				$reviews--;
			}
			$thumbnail_html .= '</div></div>';
	        $thumbnail_html .= '</div></div>';
	    }
	    return $thumbnail_html;
	}
	function vibe_better_comments($comment, $args, $depth) {
	    $GLOBALS['comment'] = $comment;
	   ?>
	   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
	     <div id="comment-<?php comment_ID(); ?>" class="comment-body">
	       <div class="comment-body-inner">
	           <div class="comment-avatar">
	             <?php echo get_avatar($comment, $size = '120', $default = ''); ?>
	           </div><!-- END avatar -->
	           <div class="comment-body-content">
	             <div class="comment-meta">
	               <?php echo get_comment_author_link(); 
	                     echo '<a href="'.htmlspecialchars( get_comment_link( $comment->comment_ID ) ) .'">'.sprintf(__('%1$s at %2$s'), get_comment_date(),  get_comment_time()).'</a>'; 
	                     comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); 
	                     edit_comment_link(__('(Edit)','vibe'),'  ','');
	               ?>
	             </div><!-- END comment-author vcard -->
	             <?php if ($comment->comment_approved == '0') : ?>
	               <em><?php _e('Your comment is awaiting moderation.') ?></em>
	               <br />
	             <?php endif; ?>
	             <div class="comment-text">
	             <?php comment_text() ?>
	             </div>
	          </div> 
	       </div>
	     </div>
	   </li>
	   <?php
	 }

	function vibe_reviews ($comment, $args, $depth) {
	    $GLOBALS['comment'] = $comment;
	   ?>
	   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
	     <div id="comment-<?php comment_ID(); ?>" class="comment-body">
	       <div class="comment-body-inner">
	           <div class="comment-avatar">
	             <?php echo get_avatar($comment, $size = '120', $default = ''); ?>
	           </div><!-- END avatar -->
	           <div class="comment-body-content">
	             <div class="comment-meta">
	               <?php echo get_comment_author_link(); 
	                     echo '<a href="'.htmlspecialchars( get_comment_link( $comment->comment_ID ) ) .'">'.sprintf(__('%1$s at %2$s'), get_comment_date(),  get_comment_time()).'</a>'; 
	                     comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); 
	                     edit_comment_link(__('(Edit)','vibe'),'  ','');
	               ?>
	             </div><!-- END comment-author vcard -->
	             <?php if ($comment->comment_approved == '0') : ?>
	               <em><?php _e('Your comment is awaiting moderation.') ?></em>
	               <br />
	             <?php endif; ?>
	             <div class="comment-text">
	             <?php
   					$commenttitle = get_comment_meta( $comment->comment_ID, 'review_title', true );
   					$commentrating = get_comment_meta( $comment->comment_ID, 'review_rating', true );
      				echo '<h3>'.$commenttitle.'</h3>';
      				echo '<div class="modern-star-rating">';
			          for($i=1;$i<=5;$i++){
			            if($commentrating >= 1){
			              echo '<span class="dashicons dashicons-star-filled"></span>';
			            }elseif(($commentrating < 1 ) && ($commentrating >= 0.3 ) ){
			              echo '<span class="dashicons dashicons-star-half"></span>';
			            }else{
			              echo '<span class="dashicons dashicons-star-empty"></span>';
			            }
			            $average_rating--;
			          }
			          echo '</div>';
	             	comment_text() ?>
	             </div>
	          </div> 
	       </div>
	     </div>
	   </li>
	   <?php
	 }

	function create_user(){
    	if ( !isset($_POST['security']) || !wp_verify_nonce($_POST['security'],'security')){
	       _e('Security check Failed. Contact Administrator.','vibe');
	       die();
	    }

	    $disable_ajax_registration = vibe_get_option('disable_ajax_registration');
        if(!empty($disable_ajax_registration))
        	return;

	    $fields = json_decode(stripslashes($_POST['fields']));
	    $user_fields = array();
	    $profile_fields = array();
	    $meta_fields = array();
	    $all_fields = array();

	    foreach($fields as $field){
	    	$all_fields[$field->id] = $field->value;
	    	if(in_array($field->id,array('user_login','user_email','user_pass','display_name'))){
	    		$user_fields[$field->id] = $field->value;
	    	}
	    }

	    $registration_code = self::option('registration_code');
	    if(!empty($registration_code)){
	    	if($all_fields['registration_code'] != $registration_code){
	    		_e('Registration code mismatch','vibe');
	    		die;
	    	}
	    }
	    
	    if(!username_exists($user_fields['user_login'])){
	    	if( email_exists( $user_fields['user_email'] )) { // user is a member 
				  _e('User email already exists','vibe');
				  die();
		    }else{ 
			    $user_id = wp_create_user( $user_fields['user_login'], $user_fields['user_pass'], $user_fields['user_email'] );
			    if(is_numeric($user_id)){
			    	$user = get_userdata($user_id);
				    wp_set_current_user( $user->ID, $user->user_login );
					wp_set_auth_cookie( $user->ID, $remember );
					do_action('vibe_projects_user_registered',$all_fields,$user_id);
					echo 1;	
			    }else{
			    	if(is_wp_error($user_id)){
			    		$error_string = $user_id->get_error_message();
   						echo $error_string;
			    	}
			    }
			    
				die();
		    }
	    }else{
	    	_e('Username already exists','vibe');
	    }
		
		die();
    }

    function forgot_password(){
    	if ( !isset($_POST['security']) || !wp_verify_nonce($_POST['security'],'security')){
	       _e('Security check Failed. Contact Administrator.','vibe');
	       die();
	    }

	    $fields = json_decode(stripslashes($_POST['fields']));
	    
	    if(!empty($_POST['user_login'])){
	    	$user = get_user_by( 'email', $_POST['user_login']);
	    	if(is_wp_error($user)){
	    		$error_string = $message->get_error_message();
    			echo '<div class="message error">' . $error_string . '</div>';
	    	}else{
	    		$message = vibe_projects_retrieve_password();
	    		if(is_wp_error($message)){
	    			$error_string = $message->get_error_message();
	    			echo '<div class="message error">' . $error_string . '</div>';
	    		}else{
	    			echo '<div class="message success">'.__('Password reset link has been sent to your email.','vibe').'</div>';
	    		}
	    	}
	    }else{
	    	echo '<div class="message error">'.__('Email address is required for password reset.','vibe').'</div>';
	    }

	    die();
    } 

    function bp_course_single_item_view($flag){

   		$course_classes = apply_filters('bp_course_single_item','modern_course_single_item',get_the_ID());
   		?>	
   		<li class="<?php echo $course_classes; ?>">
   			<div class="row">
				<div class="col-md-4">
					<?php bp_course_avatar(); ?>
				</div>

				<div class="col-md-6">
					<div class="item-title">
						<?php bp_course_title(); if(get_post_status() != 'publish'){echo '<i> ( '.get_post_status().' ) </i>';} ?>
					</div>
					<div class="item-desc"><?php 
					echo get_the_term_list(get_the_ID(),'course-cat','<ul class="course-category"><li>','</li><li>','</li></ul>');
					bp_course_desc(); 
					$instructors = apply_filters('wplms_course_instructors',get_post_field('post_author',get_the_ID()),get_the_ID());
					if(!is_array($instructors)){
						$instructors = array($instructors);
					}
					echo '<div class="instructors">';
					foreach($instructors as $instructor){
						echo '<a href="'.bp_core_get_user_domain($instructor).'" title="'.bp_core_get_username($instructor).'">'.bp_core_fetch_avatar(array(
    						'item_id' => $instructor, 
    						'type' => 'thumb')).'</a>';
					}
					?></div></div>
				</div>
				<div class="col-md-2">
					<div class="course-meta">
						<?php
							$reviews = get_post_meta(get_the_ID(),'average_rating',true);
							$students = get_post_meta(get_the_ID(),'vibe_students',true);
							$seats = get_post_meta(get_the_ID(),'vibe_max_students',true);
							$date = get_post_meta(get_the_ID(),'vibe_start_date',true);
							$duration = get_post_meta(get_the_ID(),'vibe_duration',true);
							$course_duration_parameter = apply_filters('vibe_course_duration_parameter',86400);

							echo '<ul>
								<li><span class="dashicons dashicons-groups"></span> '.$students.((empty($seats) || $seats > 9998 )?'':' / '.$seats).'</li>
								<li><span class="dashicons dashicons-clock"></span> '.$duration.' '.calculate_duration_time($course_duration_parameter).'</li>';

							if(strtotime($date) > time()){
								echo '<li>'. date_i18n( get_option( 'date_format' ), strtotime( $date ) ).'</li>';
							}

							echo '</ul><div class="modern-star-rating">';
							for($i=1;$i<=5;$i++){
								if($reviews >= 1){
									echo '<span class="dashicons dashicons-star-filled"></span>';
								}elseif(($reviews < 1 ) && ($reviews >= 0.4 ) ){
									echo '<span class="dashicons dashicons-star-half"></span>';
								}else{
									echo '<span class="dashicons dashicons-star-empty"></span>';
								}
								$reviews--;
							}
							echo '</div>';
														
						?>
						<div class="item-credits">
						<?php  bp_course_credits(); ?>
						</div>
					</div>
				</div>	
				<?php do_action( 'bp_directory_course_item' ); ?>
			</div>
		</li>	
   	<?php
   		return 1;
    }

    function get_students_undertaking($args){
    	$defaults = array(
		'course_id'=>get_the_ID(),
		'number' => 9,
		'user_id'=>get_current_user_id()
		);

		$r = wp_parse_args( $args, $defaults );
		extract( $r, EXTR_SKIP );
		global $wpdb;
		$course_meta=$wpdb->get_results($wpdb->prepare("SELECT DISTINCT user_id FROM {$wpdb->usermeta} WHERE meta_key = %s ORDER BY user_id DESC LIMIT %d, %d",'course_status'.$course_id,0,$number), ARRAY_A);
		
		$course_members = array();
		if(!empty($course_meta)){
			foreach($course_meta as $meta){
				if(is_numeric($meta['user_id']))  // META KEY is NUMERIC ONLY FOR USERIDS
					$course_members[] = $meta['user_id'];
			}
		}
		return $course_members;
    }



    function get_rating_breakup($id = null){
    	if(empty($id))
    		$id = get_the_ID();

    	global $wpdb;
    	$breakup = $wpdb->get_results($wpdb->prepare("SELECT meta_value as val,count(meta_value) as count FROM {$wpdb->commentmeta} WHERE meta_key = %s AND comment_id IN (SELECT comment_ID FROM {$wpdb->comments} WHERE comment_post_ID = %d) GROUP BY meta_value LIMIT 0,999",'review_rating',$id));

    	return $breakup;
    }

    function wplms_customizer($css){
    	if(isset($css['primary_bg'])){
    		echo '.directory #buddypress div.item-list-tabs ul>li.selected>a,#buddypress div.item-list-tabs ul>li>a:hover{color:'.$css['primary_bg'].'}';
    	}
    }

    function upload_bg($metabox){
    	$metabox['vibe_course_bg']=array( // Text Input
			'label'	=> __('Course Background image','vibe-customtypes'), // <label>
			'desc'	=> __('Background image','vibe-customtypes'), // description
			'id'	=> 'vibe_course_bg',
			'type'	=> 'image' 
		);
    	return $metabox;
    }
    function registration_code($fields){
    	$registration_code =  self::option('registration_code');
    	if(!empty($registration_code)){
    		$fields[] = array(
                          'id'=> 'registration_code',
                          'label'=> __('Registration Code','vibe'),
                          'placeholder'=> __('Enter Registration code','vibe'),
                          'field' => 'text',
                          'validation'=>'text',
                          'set' => 'meta',
                          'class'=> 'form-control no-border',
                          'required' => 1,
                        );
    	}
    	return $fields;
    }
    function bp_course_display_rating($meta,$reviews){
    	$reviews = 5 + $reviews;
		$thumbnail_html .='<div class="modern-star-rating">';
		for($i=1;$i<=5;$i++){
			if($reviews >= 1){
				$thumbnail_html .= '<span class="dashicons dashicons-star-filled"></span>';
			}elseif(($reviews < 1 ) && ($reviews >= 0.4 ) ){
				$thumbnail_html .= '<span class="dashicons dashicons-star-half"></span>';
			}else{
				$thumbnail_html .= '<span class="dashicons dashicons-star-empty"></span>';
			}
			$reviews--;
		}
		$thumbnail_html .= '</div>';
		return $thumbnail_html;
	}
	function wplms_check_instructing_courses_endpoint($template){
	  if(!is_author())
	    return $template;
	  global $wp_query;
	  $instructing_courses=apply_filters('wplms_instructing_courses_endpoint','instructing-courses');
	  if ( !isset( $wp_query->query_vars[$instructing_courses] ) ){
	     $wp_query->set( 'post_type',  array('post') );
	     return get_stylesheet_directory().'/author.php';
	  }else{
	    $wp_query->set( 'post_type',  array('course') );
	    return get_stylesheet_directory().'/author-course.php';
	  }
	}

}

$vibe = Wplms_Modern_Init::init();

if(!function_exists('vibe_better_comments')){
	function vibe_better_comments($comment, $args, $depth){
		Wplms_Modern_Init::vibe_better_comments($comment, $args, $depth);
	}
}

if(!function_exists('vibe_reviews')){
	function vibe_reviews($comment, $args, $depth){
		Wplms_Modern_Init::vibe_reviews($comment, $args, $depth);
	}
}

