<?php

class ITSEC_Malware {

	function run() {
		add_filter( 'itsec_sync_modules', array( $this, 'itsec_sync_modules' ) );

		add_filter( 'itsec_logger_displays', array( $this, 'itsec_logger_displays' ) );
		add_filter( 'itsec_logger_modules', array( $this, 'itsec_logger_modules' ) );
		add_filter( 'itsec_logger_filter_malware_data_column_details', array( $this, 'filter_logger_data_column_details' ), 10, 2 );
	}

	/**
	 * Register malware for Sync
	 *
	 * @param  array $sync_modules array of malware modules
	 *
	 * @return array                   array of logger modules
	 */
	public function itsec_sync_modules( $sync_modules ) {

		$sync_modules['malware'] = array(
			'verbs'      => array(
				'itsec-do-malware-scan'      => 'Ithemes_Sync_Verb_ITSEC_Malware_Do_Scan',
				'itsec-get-malware-scan-log' => 'Ithemes_Sync_Verb_ITSEC_Get_Malware_Scan_Log',
			),
			'everything' => 'itsec-get-malware-scan-log',
			'path'       => dirname( __FILE__ ),
		);

		return $sync_modules;

	}

	/**
	 * Register malware for logger
	 *
	 * @since 4.4
	 *
	 * @param  array $logger_modules array of logger modules
	 *
	 * @return array                   array of logger modules
	 */
	public function itsec_logger_modules( $logger_modules ) {
		$logger_modules['malware'] = array(
			'type'     => 'malware',
			'function' => __( 'Malware Scan', 'better-wp-security' ),
		);

		return $logger_modules;

	}

	/**
	 * Array of metaboxes for the logs screen
	 *
	 * @since 4.4
	 *
	 * @param array $displays metabox array
	 *
	 * @return array metabox array
	 */
	public function itsec_logger_displays( $displays ) {
		$displays[] = array(
			'module'   => 'malware',
			'title'    => __( 'Malware Scan', 'better-wp-security' ),
			'callback' => array( $this, 'logs_metabox_content' )
		);

		return $displays;
	}

	/**
	 * Render the settings metabox
	 *
	 * @return void
	 */
	public function logs_metabox_content() {

		if ( ! class_exists( 'ITSEC_Malware_Log' ) ) {
			require( dirname( __FILE__ ) . '/class-itsec-malware-log.php' );
		}

		$log_display = new ITSEC_Malware_Log();

		$log_display->prepare_items();
		$log_display->display();

	}

	public function filter_logger_data_column_details( $details, $data ) {
		if ( is_wp_error( $data ) || ( ! empty( $data ) && ! empty( $data['SCAN']['SITE'] ) ) ) {
			// Results for Sucuri scans.
			
			require_once( dirname( __FILE__ ) . '/class-itsec-malware-scan-results-template.php' );
			
			$details = "<div class='itsec-malware-scan-results-wrapper'>\n";
			$details .= ITSEC_Malware_Scan_Results_Template::get_html( $data, true );
			$details .= "</div>\n";
		}
		
		return $details;
	}

}
